IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_EST_PROD_CPL_FACE_PERMANENTE]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [DBO].[P_EST_PROD_CPL_FACE_PERMANENTE]
GO
GO
CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_FACE_PERMANENTE] AS 
SET NOCOUNT ON;
	CREATE TABLE #RsProdProc (CD_EMP INT, 
							  CD_FILIAL INT, 
							  QTDE_FACE MONEY, 
							  QTDE_DIA_VALID INT,
							  CD_PROD INT,
							  CD_USU INT,
							  FLAG_PROC_ZERADO INT)
	
INSERT INTO #RsProdProc
SELECT
	CD_EMP,
	CD_FILIAL,
	QTDE_FACE,
	QTDE_DIA_VALID,
	CD_PROD,
	CD_USU,
	FLAG_PROC_ZERADO
FROM
	EST_PROD_CPL_FACE_PERMANENTE
WHERE
	FLAG_PROC_ZERADO=0

    UPDATE
	   EST_PROD_CPL_MEDIAF
    SET
	   EST_PROD_CPL_MEDIAF.QTDE_FACEAMENTO = P.QTDE_FACE, 
	   EST_PROD_CPL_MEDIAF.VALID_QTDE_FACEAMENTO = CONVERT(CHAR(10),GETDATE() + P.QTDE_DIA_VALID,112),
	   EST_PROD_CPL_MEDIAF.CD_USU =  P.CD_USU	
    FROM         
	   #RsProdProc P INNER JOIN EST_PROD_CPL_MEDIAF ON 
	   P.CD_EMP = EST_PROD_CPL_MEDIAF.CD_EMP AND 
	   P.CD_FILIAL = EST_PROD_CPL_MEDIAF.CD_FILIAL AND 
	   P.CD_PROD = EST_PROD_CPL_MEDIAF.CD_PROD
    WHERE
	   P.QTDE_FACE > 0 
	   AND EST_PROD_CPL_MEDIAF.QTDE_FACEAMENTO = 0

    UPDATE
	   EST_PROD_CPL_MEDIAF
    SET
	   EST_PROD_CPL_MEDIAF.QTDE_FACEAMENTO = 0, 
	   EST_PROD_CPL_MEDIAF.VALID_QTDE_FACEAMENTO = NULL,
	   EST_PROD_CPL_MEDIAF.CD_USU =  P.CD_USU	
    FROM         
	   #RsProdProc P  INNER JOIN EST_PROD_CPL_MEDIAF ON 
	   P.CD_EMP = EST_PROD_CPL_MEDIAF.CD_EMP AND 
	   P.CD_FILIAL = EST_PROD_CPL_MEDIAF.CD_FILIAL AND 
	   P.CD_PROD = EST_PROD_CPL_MEDIAF.CD_PROD
    WHERE
	   P.QTDE_FACE = 0 
	   AND EST_PROD_CPL_MEDIAF.QTDE_FACEAMENTO > 0
	   
UPDATE
	EST_PROD_CPL_FACE_PERMANENTE
SET 
	EST_PROD_CPL_FACE_PERMANENTE.FLAG_PROC_ZERADO=1
FROM
	EST_PROD_CPL_FACE_PERMANENTE INNER JOIN #RsProdProc P ON
	EST_PROD_CPL_FACE_PERMANENTE.CD_EMP = P.CD_EMP AND
	EST_PROD_CPL_FACE_PERMANENTE.CD_FILIAL = P.CD_FILIAL AND
	EST_PROD_CPL_FACE_PERMANENTE.CD_PROD = P.CD_PROD
WHERE
	EST_PROD_CPL_FACE_PERMANENTE.FLAG_PROC_ZERADO=0
GO


